///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _ReplicationDlg_CPP
#define _ReplicationDlg_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>

#include "../Resources/Resource.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedClasses/CStatusDlg/CStatusDlg.H"
#include "../../SharedSource/NSWFL.H"

#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/Replication.H"
#include "../../SharedSource/Common.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/SplashDlg.H"
#include "../Dialogs/ReplicationDlg.H"
#include "../Dialogs/RepIssues.H"
#include "../Dialogs/PendingTrans.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
WNDPROC gpOldReplicationListProc;

HWND hReplication = NULL;

HWND hTablesList = NULL;

bool bProcessing = false;

DWORD WINAPI ProcessTablesGrid_Thread(LPVOID lpData);
HANDLE ProcessTablesGrid_Thread_Handle = NULL;
DWORD ProcessTablesGrid_Thread_ID = 0;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ReplicationDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

	static HIMAGELIST hImgList;

    //--------------------------------------------------------------------------

    if(uMsg == WM_INITDIALOG)
    {
        hReplication = hWnd;

        char sCaption[1024];
		sprintf_s(sCaption, sizeof(sCaption), "%s :: %s", gsTitleCaption, "Replication");
        SendMessage(hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)sCaption);
        SendMessage(hWnd, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

		LV_COLUMN MyLVColumb;
		memset(&MyLVColumb, 0, sizeof(MyLVColumb));

		hTablesList = GetDlgItem(hWnd, IDC_TALBES);

        gpOldReplicationListProc = (WNDPROC) SetWindowLongPtr(hTablesList, GWLP_WNDPROC, (long) &ReplicationListProc);

		// Create Listview columbs
        MyLVColumb.cx        = 150;
        MyLVColumb.pszText   = "Database";
        MyLVColumb.iSubItem  = 0;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hTablesList, 0, &MyLVColumb);

        MyLVColumb.cx        = 250;
        MyLVColumb.pszText   = "Table Name";
        MyLVColumb.iSubItem  = 1;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hTablesList, 1, &MyLVColumb);

        MyLVColumb.cx        = 0;
        MyLVColumb.pszText   = "Primary Key";
        MyLVColumb.iSubItem  = 2;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hTablesList, 2, &MyLVColumb);

        MyLVColumb.cx        = 300;
        MyLVColumb.pszText   = "Status";
        MyLVColumb.iSubItem  = 3;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hTablesList, 3, &MyLVColumb);

		hImgList = ImageList_Create(GetSystemMetrics(SM_CXSMICON), GetSystemMetrics(SM_CYSMICON), TRUE, 1, 1);

		HICON hIcon = NULL;
		
        hIcon = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_AVAILFORREP));
        ImageList_AddIcon(hImgList, (HICON)hIcon);
        DeleteObject((HICON)hIcon);

        hIcon = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_NOTAVAILFORREP));
        ImageList_AddIcon(hImgList, (HICON)hIcon);
        DeleteObject((HICON)hIcon);

        hIcon = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_REPLICATING));
        ImageList_AddIcon(hImgList, (HICON)hIcon);
        DeleteObject((HICON)hIcon);

        hIcon = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_REPERROR));
        ImageList_AddIcon(hImgList, (HICON)hIcon);
        DeleteObject((HICON)hIcon);

        ListView_SetImageList(hTablesList, hImgList, LVSIL_SMALL);

		PopTablesGrid(hTablesList);

		CenterWindow(hWnd);

        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_COMMAND)
    {
		if(wParam == ID_REPLICATION_SELECTALL)
        {
			CheckGridRows(hTablesList, true);
			return TRUE;
		}

		if(wParam == ID_REPLICATION_DESELECTALL)
        {
			CheckGridRows(hTablesList, false);
			return TRUE;
		}

		if(wParam == ID_REPLICATION_SELECTALLOFTHISDATABASE)
        {
			CheckGridDatabaseRows(hTablesList, true);
			return TRUE;
		}

		if(wParam == ID_REPLICATION_DESELECTALLOFTHISDATABASE)
        {
			CheckGridDatabaseRows(hTablesList, false);
			return TRUE;
		}

		if(wParam == ID_REPLICATION_SELECTALLHIGHLIGHTED)
        {
			CheckGridHighlightedRows(hTablesList, true);
			return TRUE;
		}

		if(wParam == ID_REPLICATION_DESELECTALLHIGHLIGHTED)
        {
			CheckGridHighlightedRows(hTablesList, false);
			return TRUE;
		}

		if(wParam == ID_REPLICATION_CANCEL)
        {
			return TRUE;
		}

		if(wParam == ID_PENDINGTRANSACTIONS)
        {
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_PENDINGTRANS), hWnd, (DLGPROC)PendingTransDialog);
			return TRUE;
		}

		if(wParam == ID_CHKALL)
        {
			CheckGridRows(hTablesList, true);
			return TRUE;
		}

        if(wParam == ID_CHKNONE)
        {
			CheckGridRows(hTablesList, false);
			return TRUE;
		}

		if(wParam == ID_APPLY)
        {
			bProcessing = true;
			ProcessTablesGrid_Thread_Handle = CreateThread(NULL, 0 ,ProcessTablesGrid_Thread, (LPVOID)0, 0, &ProcessTablesGrid_Thread_ID);

			int iLVStyle = LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT;
			SendMessage(hTablesList, (UINT)LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)iLVStyle);

			return TRUE;
        }

        if(wParam == ID_CANCEL)
        {
			EndDialog(hWnd,0);
			DestroyWindow(hWnd);
			return TRUE;
        }
		
		return FALSE;
    }

	//--------------------------------------------------------------------------

	if(uMsg == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(hWnd, &ThisPS);

        // Any painting should be done here

        EndPaint(hWnd, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_CLOSE) 
    {
        if(bProcessing)
		{
			MessageBox(hWnd, "Please wait until the process is complete.", gsTitleCaption, NULL);
		}
		else{
			EndDialog(hWnd,0);
			DestroyWindow(hWnd);
		}
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

LRESULT CALLBACK ReplicationListProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	LRESULT lResult = CallWindowProc(gpOldReplicationListProc, hWnd, uMsg, wParam, lParam);

	if(uMsg == WM_RBUTTONDOWN)
    {
		int iSelected =  ListView_GetSelectedCount(hWnd);

		// Load menu
    	HMENU hMenu = LoadMenu(ghAppInstance, MAKEINTRESOURCE(IDR_REPLICATIONLIST) );
   		hMenu = GetSubMenu(hMenu, 0);

		if(iSelected > 1)
		{
			//EnableMenuItem(hMenu, ID_REPLICATION_SELECTALL, MF_ENABLED);
			//EnableMenuItem(hMenu, ID_REPLICATION_DESELECTALL, MF_ENABLED);
			//EnableMenuItem(hMenu, ID_REPLICATION_SELECTALLOFTHISDATABASE, MF_ENABLED);
			//EnableMenuItem(hMenu, ID_REPLICATION_DESELECTALLOFTHISDATABASE, MF_ENABLED);
			EnableMenuItem(hMenu, ID_REPLICATION_SELECTALLHIGHLIGHTED, MF_ENABLED);
			EnableMenuItem(hMenu, ID_REPLICATION_DESELECTALLHIGHLIGHTED, MF_ENABLED);
			EnableMenuItem(hMenu, ID_REPLICATION_CANCEL, MF_ENABLED);
		}
		else{
			EnableMenuItem(hMenu, ID_REPLICATION_SELECTALL, MF_ENABLED);
			EnableMenuItem(hMenu, ID_REPLICATION_DESELECTALL, MF_ENABLED);
			EnableMenuItem(hMenu, ID_REPLICATION_SELECTALLOFTHISDATABASE, MF_ENABLED);
			EnableMenuItem(hMenu, ID_REPLICATION_DESELECTALLOFTHISDATABASE, MF_ENABLED);
			//EnableMenuItem(hMenu, ID_REPLICATION_SELECTALLHIGHLIGHTED, MF_ENABLED);
			//EnableMenuItem(hMenu, ID_REPLICATION_DESELECTALLHIGHLIGHTED, MF_ENABLED);
			EnableMenuItem(hMenu, ID_REPLICATION_CANCEL, MF_ENABLED);
		}

        POINT xy;
        GetCursorPos(&xy);
        TrackPopupMenuEx(hMenu, TPM_LEFTALIGN|TPM_RIGHTBUTTON, (xy.x) + 1, xy.y, hReplication, NULL);
        DestroyMenu(hMenu);
    }

    return lResult;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CheckGridHighlightedRows(HWND hGrid, bool bCheck)
{
	int iItem = -1;

	while((iItem = ListView_GetNextItem(hGrid, iItem, LVNI_SELECTED)) != -1)
	{
		ListView_SetCheckState(hGrid, iItem, (BOOL) bCheck);
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CheckGridDatabaseRows(HWND hGrid, bool bCheck)
{
	char sDatabase[1024];
	char sText[1024];
	int iItem = -1;

	iItem = ListView_GetNextItem(hGrid, iItem, LVNI_SELECTED);

	if(iItem != -1)
	{
		ListView_GetItemText(hGrid, iItem, 0, sDatabase, sizeof(sDatabase));

		iItem = -1;
		
		while((iItem = ListView_GetNextItem(hGrid, iItem, LVNI_ALL)) != -1)
		{
			ListView_GetItemText(hGrid, iItem, 0, sText, sizeof(sText));

			if(_strcmpi(sDatabase, sText) == 0)
			{
				ListView_SetCheckState(hGrid, iItem, (BOOL) bCheck);
			}
			
		}
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CheckGridRows(HWND hGrid, bool bCheck)
{
	int iRow = 0;
	int iItems = ListView_GetItemCount(hGrid);

	while(iRow < iItems)
    {
		ListView_SetCheckState(hGrid, iRow, (BOOL) bCheck);
		iRow++;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool PopTablesGrid(HWND hGrid)
{
	int iRepTriggers = 0;
	int iRow = 0;
	int iItem = 0;
	int iTempSz = 0;
	int iChecked = 0;
	int iImage = 0;
	bool bGotPK = true;

	char sDatabase[255];
	char sTemp[5120];
	char sSQL[5120];

	CSQL cSQL;
	CRecordSet rsDatabases;
	CRecordSet rsTemp;

	LV_ITEM MyLVItem;
	memset(&MyLVItem, 0, sizeof(MyLVItem));

    int iLVStyle = LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT | LVS_EX_CHECKBOXES;
    SendMessage(hGrid, (UINT)LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)iLVStyle);

	if(!cSQL.Connect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, "Master", gsDBMode))
	{
		MessageBox(hMainDialog, "Failed to connect to the SQL server.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
		return false;
	}
	
	CStatusDlg MyStatDlg;

	MyStatDlg.Load(NULL, "Please wait...", IDI_MAIN, false);
	MyStatDlg.Show();

	strcpy_s(sSQL, sizeof(sSQL), 
		"SELECT [Name] FROM [SysDatabases]"
		" WHERE [Name] NOT LIKE 'SQLExch_%'"
		" AND [Name] NOT IN ('Master', 'Model', 'MSDB', 'TempDB')"
		" ORDER BY [Name]");
	cSQL.Execute(sSQL, &rsDatabases);	

	while(rsDatabases.Fetch())
	{
		rsDatabases.sColumnEx(1, sDatabase, sizeof(sDatabase), &iTempSz);

		sprintf_s(sTemp, sizeof(sTemp), "Retrieving SQL Resources. [%s]", sDatabase);
		MyStatDlg.SetText(sTemp);

	sprintf_s(sSQL, sizeof(sSQL), "SELECT '%s' AS [DB], [A].[ID] AS [TableID], [A].[Name] AS [TableName],"
		" IsNull((SELECT [TC].[Constraint_Name]"
		" FROM [%s].[Information_Schema].[Table_Constraints] [TC]"
		" WHERE [TC].[Constraint_Type] = 'Primary Key' and [TC].[Table_Name] = [A].[Name]), '') AS [PKName],"
		" (SELECT Count([C].[ID]) FROM [%s].[%s].[SysObjects] AS [C]"
		" WHERE [C].[Parent_Obj] = [A].[ID] AND LEFT([C].[NAME], 8) = 'SQLExch_'),"
		" (SELECT Count([C].[ID]) FROM [%s].[%s].[SysObjects] AS [C]"
		" WHERE [C].[Parent_Obj] = [A].[ID] AND LEFT([C].[NAME], 8) = 'SQLExch_'"
		" AND LEFT([C].[NAME], 8 + %d) = 'SQLExch_%s')"
		" FROM [%s].[%s].[SysObjects] AS [A]"
		" WHERE [A].[xType] = 'U' AND [A].[Name] <> 'dtProperties'"
		" AND LEFT([A].[NAME], 8) <> 'SQLExch_' AND LEFT([A].[NAME], 3) <> 'SYS'"
		" ORDER BY [A].[Name]",
		sDatabase, sDatabase, sDatabase, gsDefaultDBO, sDatabase, gsDefaultDBO,
		strlen(sDatabase), sDatabase, sDatabase, gsDefaultDBO);

		cSQL.Execute(sSQL, &rsTemp);

		iRow = 0;

		MyStatDlg.SetProgressRange(0, rsTemp.RowCount);

		sprintf_s(sTemp, sizeof(sTemp), "Loading SQL Resources. [%s]", sDatabase);
		MyStatDlg.SetText(sTemp);

		while(rsTemp.Fetch())
		{
			//Database Name.
			MyLVItem.pszText  = sDatabase;
			MyLVItem.mask     = LVIF_TEXT;
			MyLVItem.iSubItem = 0;
			MyLVItem.iItem    = iItem;
			ListView_InsertItem(hGrid, &MyLVItem);

			//Table Name.
			rsTemp.sColumnEx(3, sTemp, sizeof(sTemp), &iTempSz);
			MyLVItem.pszText  = sTemp;
			MyLVItem.mask     = LVIF_TEXT;
			MyLVItem.iSubItem = 1;
			MyLVItem.iItem    = iItem;
			ListView_SetItem(hGrid, &MyLVItem);

			//Primary Key Name.
			rsTemp.sColumnEx(4, sTemp, sizeof(sTemp), &iTempSz);
			MyLVItem.pszText  = sTemp;
			MyLVItem.mask     = LVIF_TEXT;
			MyLVItem.iSubItem = 2;
			MyLVItem.iItem    = iItem;
			ListView_SetItem(hGrid, &MyLVItem);

			if(strlen(sTemp) > 0)
			{
				bGotPK = true;
			}
			else {
				bGotPK = false;
			}

			//Number of replication triggers.
			iRepTriggers = rsTemp.lColumn(5);
			if(iRepTriggers > 0)
			{
				ListView_SetCheckState(hGrid, iItem, TRUE);
				iChecked = 1;
			}
			else{
				ListView_SetCheckState(hGrid, iItem, FALSE);
				iChecked = 0;
			}

			//Number of valid replication triggers
			if(iRepTriggers != rsTemp.lColumn(6))
			{
				strcpy_s(sTemp, sizeof(sTemp), "Replication error. This replication should be dropped.");
				iImage = 3;
			}
			else{
				if(iChecked == 1) {
					strcpy_s(sTemp, sizeof(sTemp), "Replicating.");
					iImage = 2;
				}
				else if(bGotPK) {
					strcpy_s(sTemp, sizeof(sTemp), "Not Replicating.");
					iImage = 0;
				}
				else{
					strcpy_s(sTemp, sizeof(sTemp), "Cannot Replicate. (No Primary Key)");
					iImage = 1;
				}
			}

			MyLVItem.mask = LVIF_PARAM|LVIF_IMAGE;
			MyLVItem.iSubItem = 0;
			MyLVItem.iImage   = iImage;
			MyLVItem.lParam   = iImage;
			MyLVItem.iItem    = iItem;
			ListView_SetItem(hGrid, &MyLVItem);

			MyLVItem.pszText  = sTemp;
			MyLVItem.mask     = LVIF_TEXT;
			MyLVItem.iSubItem = 3;
			MyLVItem.iItem    = iItem;
			ListView_SetItem(hGrid, &MyLVItem);

			iItem++;
			iRow++;

			MyStatDlg.SetProgressPos(iRow);
			//Sleep(1);
		}
	}

	MyStatDlg.SetText("Loading SQL resources complete!");
	MyStatDlg.SetCaption("Complete.");

	MyStatDlg.SetButtonText("Ok");

	MyStatDlg.EnableButton();

	while(MyStatDlg.IsDlgVisible())
	{
		Sleep(1);
	}

	MyStatDlg.Unload();

	cSQL.Disconnect();

	SetForegroundWindow(hReplication);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI ProcessTablesGrid_Thread(LPVOID lpData)
{
	HWND hCmdApply = GetDlgItem(hReplication, ID_APPLY);
	HWND hCmdClose = GetDlgItem(hReplication, ID_CANCEL);
	HWND hCmdAll   = GetDlgItem(hReplication, ID_CHKALL);
	HWND hCmdNone  = GetDlgItem(hReplication, ID_CHKNONE);

	EnableWindow(hCmdApply, FALSE);
	EnableWindow(hCmdClose, FALSE);
	EnableWindow(hCmdAll, FALSE);
	EnableWindow(hCmdNone, FALSE);

	ProcessTablesGrid(hTablesList);

	EnableWindow(hCmdClose, TRUE);

	bProcessing = false;

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ProcessTablesGrid(HWND hGrid)
{
    int iRow = 0;
	int iParam = 0;
	int iTempSz = 0;
	int iItems = ListView_GetItemCount(hGrid);
	char sTableName[1024];
	char sDatabase[255];
	char sLastDB[255];

	CSQL cSQL;
	CRecordSet rsDatabases;

	CStatusDlg MyStatDlg;

	MyStatDlg.Load(hReplication, "Creating replications.", IDI_MAIN, false);
	EnableWindow(hReplication, FALSE);
	MyStatDlg.Show();

	MyStatDlg.SetProgressRange(0, iItems);

	Sleep(1500);

	while(iRow < iItems)
    {
		ListView_GetItemText(hGrid, iRow, 0, sDatabase, sizeof(sDatabase));
		ListView_GetItemText(hGrid, iRow, 1, sTableName, sizeof(sTableName));

		if(_strcmpi(sDatabase, sLastDB) != 0)
		{
			if(strlen(sLastDB) > 0)
			{
				cSQL.Disconnect();
			}
			
			MyStatDlg.SetText("Connecting to the SQL server.");

			if(!cSQL.Connect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, sDatabase, gsDBMode))
			{
				MessageBox(hReplication, "Failed to connect to the SQL server.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
				return false;
			}

			MyStatDlg.SetText("Updating replication settings.");

			strcpy_s(sLastDB, sizeof(sLastDB), sDatabase);
		}

		/*
			lParam:
				0: Not (But Can) replicating.
				1: Cannot replicate.
				2: Currently replicating.
				3: Currently replicating.
					(Trigger name does not match database name, Bad replication!)
		*/
		iParam = GetListItemlParam(hGrid, iRow, 0);

		//If the item is checked.
		if(ListView_GetCheckState(hGrid, iRow))
		{
			//If the item was previously unchecked.
			if(iParam == 0)
			{
				if(CreateReplicationEx(&cSQL, gsReplicationDB, sDatabase, gsDefaultDBO, sTableName, hGrid, 3, iRow))
				{
					SetStatus(hGrid, 3, iRow, "Create OK.");
				}
				else SetStatus(hGrid, 3, iRow, "Create Failed!");
			}
		}
		else { //If the item is unchecked.

			//If the item was previously checked.
			if(iParam == 2 || iParam == 3)
			{
				SetStatus(hGrid, 3, iRow, "Dropping Triggers.");
				if(DropReplicationTriggers(&cSQL, sDatabase, sTableName))
				{
					SetStatus(hGrid, 3, iRow, "Dropping tables.");
					if(DropReplicationTables(&cSQL, gsReplicationDB, sDatabase, gsDefaultDBO, sTableName))
					{
						SetStatus(hGrid, 3, iRow, "Drop OK.");
					}
					else SetStatus(hGrid, 3, iRow, "Drop Failed!");
				}
				else SetStatus(hGrid, 3, iRow, "Drop Failed!");
			}
		}

        iRow++;

		MyStatDlg.SetProgressPos(iRow);
		//Sleep(1);
    }

	if(strlen(sLastDB) > 0)
	{
		cSQL.Disconnect();
	}

	if(!cSQL.Connect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, "Master", gsDBMode))
	{
		MessageBox(hReplication, "Failed to connect to the SQL server.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
		return false;
	}

	GenerateReplicationScripts(&MyStatDlg, gsReplicationDB, gsDefaultDBO, true);
			
	MyStatDlg.SetText("Complete.");

	MyStatDlg.SetButtonText("Ok");

	MyStatDlg.EnableButton();

	EnableWindow(hReplication, TRUE);

	while(MyStatDlg.IsDlgVisible())
	{
		Sleep(1);
	}

	MyStatDlg.Unload();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

